/************************************************************************************************************\

Module Name:    CopyModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_CopyModule_H
#define INC_CopyModule_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleThread.h"
#include "ModuleLink.h"
#include "LBlit.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      CopyModule

Description:    This module copy buffers from the input to the output buffers.

Comments:

\************************************************************************************************************/
typedef struct tagCopyModule
{
    LDeviceThread_Handle    hDevThread;
    LBlit_Handle            hBlit;
    ModuleThread            oCpuThread;
    ModuleLinkInput         oInLink;
    ModuleLink              oOutLink;
    MBOOL                   bLinear;
    LPOS32                  oSrcPos;
    LRECT32                 oDstRect;
    MCHAR8                  szModuleName[16];

} CopyModule;

#define CopyModule_Construct { /*.hDeviceThread   =*/ MNULL, \
                               /*.hBlit           =*/ MNULL, \
                               /*.oCpuThread      =*/ ModuleThread_Construct, \
                               /*.oInLink         =*/ ModuleLinkInput_Construct, \
                               /*.oOutLink        =*/ ModuleLink_Construct, \
                               /*.bLinear         =*/ MFALSE }

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus CopyMod_Init(CopyModule*         poCopyMod,
                     LDevice_Handle      hDevice,
                     MUINT               uiOutBufferCount,
                     LBuffer_Attributes* poOutBufferAttributes);
void CopyMod_Cleanup(CopyModule* poCopyMod);
LStatus CopyMod_Start(CopyModule* poCopyMod);
void CopyMod_Stop(CopyModule* poCopyMod);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_CopyModule_H
